Rem  Copyright (c) 1998 by Oracle Corporation 
Rem    NAME
Rem     ExcelSolutionDemo.sql - Make use of APIs exposed by ExcelSolutions.sql
Rem    DESCRIPTION
REM		Gives a little demonstration on using the Oracle COM callouts capabilities of
REM		Oracle. Connects to the scott/tiger database and pumps the data into the Excel spreadsheet.
REM		
Rem    MODIFIED   (MM/DD/YY)
Rem     kfleong	   01/05/98 -  Creation
REM
REM	

set serveroutput on;
declare 
result1 emp.EMPNO%TYPE;
	CURSOR c1 IS	
		SELECT EMPNO, ENAME, JOB, SAL, HIREDATE FROM emp;
error_message varchar2(1200);
n binary_integer:=2;
i binary_integer;
filename varchar2(255);
cellIndex varchar2(40);
cellValue varchar2(40);
cellColumn varchar2(10);
returnedTime varchar2(20);
currencyvalue double precision;
datevalue DATE;
empno binary_integer;

looptext varchar2(20);

error_src varchar2(255);
error_description varchar2(255);
error_helpfile varchar2(255);
error_helpID binary_integer;

begin
filename:='c:\excel';
i:=ORDExcel.CreateExcelWorkSheet('');
i:=ORDExcel.InsertData('A1', 'EmpNo', 'BSTR');
i:=ORDExcel.InsertData('B1', 'Name', 'BSTR');
i:=ORDExcel.InsertData('C1', 'Job', 'BSTR');
i:=ORDExcel.InsertData('D1', 'Salary', 'BSTR');
i:=ORDExcel.InsertData('C1', 'HireDate', 'BSTR');

For c1_rec IN c1 LOOP

cellColumn:=TO_CHAR(n);

cellIndex:=CONCAT('A',cellColumn);
cellValue:=TO_CHAR(c1_rec.EMPNO);
empno:=cellValue;
i:=ORDExcel.InsertData(cellIndex, empno, 'I2');


cellIndex:=CONCAT('B',cellColumn);
cellValue:=c1_rec.ENAME;
i:=ORDExcel.InsertData(cellIndex, cellValue, 'BSTR');

cellIndex:=CONCAT('C',cellColumn);
cellValue:=c1_rec.JOB;
i:=ORDExcel.InsertData(cellIndex, cellValue, 'BSTR');



cellIndex:=CONCAT('D',cellColumn);
cellValue:=c1_rec.SAL;
currencyValue:=cellValue;
i:=ORDExcel.InsertData(cellIndex, currencyValue, 'CY');



cellIndex:=CONCAT('E',cellColumn);
dateValue:=c1_rec.HIREDATE;
i:=ORDExcel.InsertData(cellIndex, dateValue, 'DATE');


n:=n+1;
END LOOP;
i:=ORDExcel.InsertChart(200,200,250,250,'D2:D15','xlPie');

select TO_CHAR(SYSDATE, 'HH24MISS') into returnedTime from dual;
filename:=CONCAT(filename, returnedTime);

i:=ORDExcel.SaveExcelFile(filename);
i:=ORDExcel.ExitExcel();
end;
